/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.bar.GuiMergedChemicalBar;
import mekanism.client.gui.element.button.GuiGasMode;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class GuiChemicalTank
extends GuiConfigurableTile<TileEntityChemicalTank, MekanismTileContainer<TileEntityChemicalTank>> {
    public GuiChemicalTank(MekanismTileContainer<TileEntityChemicalTank> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        this.addRenderableWidget(GuiSideHolder.armorHolder(this));
        super.addGuiElements();
        this.addRenderableWidget(new GuiMergedChemicalBar<TileEntityChemicalTank>(this, (TileEntityChemicalTank)this.tile, ((TileEntityChemicalTank)this.tile).getChemicalTank(), 42, 16, 116, 10, true));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 42, 37, 118, 28, () -> {
            ArrayList<Component> ret = new ArrayList<Component>();
            switch (((TileEntityChemicalTank)this.tile).getChemicalTank().getCurrent()) {
                case EMPTY: {
                    ret.add((Component)MekanismLang.CHEMICAL.translate(MekanismLang.NONE));
                    ret.add((Component)MekanismLang.GENERIC_FRACTION.translate(0, ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE ? MekanismLang.INFINITE : TextUtils.format(((TileEntityChemicalTank)this.tile).getTier().getStorage())));
                    break;
                }
                case GAS: {
                    this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getGasTank(), MekanismLang.GAS);
                    break;
                }
                case INFUSION: {
                    this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getInfusionTank(), MekanismLang.INFUSE_TYPE);
                    break;
                }
                case PIGMENT: {
                    this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getPigmentTank(), MekanismLang.PIGMENT);
                    break;
                }
                case SLURRY: {
                    this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getSlurryTank(), MekanismLang.SLURRY);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown current type");
                }
            }
            return ret;
        }));
        this.addRenderableWidget(new GuiGasMode((IGuiWrapper)this, 159, 72, true, () -> ((TileEntityChemicalTank)this.tile).dumping, ((TileEntityChemicalTank)this.tile).m_58899_(), 0));
    }

    private void addStored(List<Component> ret, IChemicalTank<?, ?> tank, ILangEntry langKey) {
        ret.add((Component)langKey.translate(tank.getStack()));
        if (!tank.isEmpty() && ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE) {
            ret.add((Component)MekanismLang.INFINITE.translate(new Object[0]));
        } else {
            ret.add((Component)MekanismLang.GENERIC_FRACTION.translate(TextUtils.format(tank.getStored()), ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE ? MekanismLang.INFINITE : TextUtils.format(tank.getCapacity())));
        }
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

